
IF EXISTS
(
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS 
		WHERE TABLE_NAME = 'EST_PROD' AND COLUMN_NAME = 'UUID'
		AND DATA_TYPE = 'varchar'
)
BEGIN

	ALTER TABLE dbo.EST_PROD DROP CONSTRAINT DF_EST_PROD_UUID ;	
	ALTER TABLE dbo.EST_PROD ALTER COLUMN UUID uniqueidentifier  NULL;
	ALTER TABLE dbo.EST_PROD ADD CONSTRAINT
		DF_EST_PROD_UUID DEFAULT NEWID() FOR UUID;
END
go

IF NOT EXISTS
(
    SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'EST_PROD' AND COLUMN_NAME = 'UUID'
)
BEGIN
	ALTER TABLE dbo.EST_PROD ADD
		UUID uniqueidentifier  NULL;

	ALTER TABLE dbo.EST_PROD ADD CONSTRAINT
		DF_EST_PROD_UUID DEFAULT NEWID() FOR UUID;
END